<?php get_header(); 
if(get_field('header_banner')){
	$header_banner = get_field('header_banner');
	$header_banner_url = $header_banner['sizes']['c_slider'];
}else{
	$header_banner_url = get_template_directory_uri().'/css/bg/search.jpg';
}
?>	
	
<div class="container-fluid top_page top_page_single relative" <?php echo ' style="background:url('.$header_banner_url.') no-repeat center center / cover"';?>>
	<span class="shadow"></span>
	<div class="container">
		<div class="row">
			<div class="top_page_title_part2 text-left col-sm-12">
			<?php
			$strlen_title = strlen(get_the_title());
			if($strlen_title>40){$class_title = 'small';}
			?>	
			<h1 class="white light <?php echo $class_title;?>">Recherche</h1>
			<?php
			//if ( function_exists('yoast_breadcrumb') ) {yoast_breadcrumb('<p id="breadcrumbs" class="white">','</p>');}
			?>			
			</div>
		</div>
	</div>	
<span class="part part_left"></span>
<span class="part part_right"></span>	
</div>
<div class="bg_img container-fluid ">
		
<div class="container">	
		
	<div id="content" class="clearfix row">
	
		<div id="main" class="col col-lg-12 clearfix" role="main">
		
			<div class="page-header">
				<p><?php _e("Search Results for","wpbootstrap"); ?>:<br />
					<strong class="orange"><?php echo esc_attr(get_search_query()); ?></strong>
				</p>
			</div>

			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
			
			<article id="post-<?php the_ID(); ?>" <?php post_class('clearfix post_content search_link transition'); ?> role="article">					
					<h3><?php the_title(); ?></h3>
					<?php the_excerpt('<span class="read-more">' . __("Read more on","wpbootstrap") . ' "'.the_title('', '', false).'" &raquo;</span>'); ?>
					<a href="<?php echo get_permalink();?>" class="btn btn-sm white bg_orange border_radius border_orange">Lire la suite</a>
			</article> <!-- end article -->
			<hr />
			<?php endwhile; ?>	
			
			<?php if (function_exists('wp_bootstrap_page_navi')) { // if expirimental feature is active ?>
				
				<?php wp_bootstrap_page_navi(); // use the page navi function ?>
				
			<?php } else { // if it is disabled, display regular wp prev & next links ?>
				<nav class="wp-prev-next">
					<ul class="clearfix">
						<li class="prev-link"><?php next_posts_link(_e('&laquo; Older Entries', "wpbootstrap")) ?></li>
						<li class="next-link"><?php previous_posts_link(_e('Newer Entries &raquo;', "wpbootstrap")) ?></li>
					</ul>
				</nav>
			<?php } ?>			
			
			<?php else : ?>
			
			<!-- this area shows up if there are no results -->
			
			<article id="post-not-found">
				<header>
					<h1><?php _e("Not Found", "wpbootstrap"); ?></h1>
				</header>
				<section class="post_content">
					<p><?php _e("Sorry, but the requested resource was not found on this site.", "wpbootstrap"); ?></p>
				</section>
				<footer>
				</footer>
			</article>
			
			<?php endif; ?>
	
		</div> <!-- end #main -->

	</div> <!-- end #content -->

</div>	

</div>
	
<?php get_footer(); ?>