<?php
/*
  * template name: Espace recrutement
  * */
get_header();
if(get_field('job_header_title')){
    $title = get_field('job_header_title');
}else{
    $title = get_the_title();
}

?>
<div class="container-fluid  p-2 p-md-5" >
    <div class="container p-2 p-md-5">
        <div class="row">
            <div class="col-12  col-xl-5 post_content">
                <?php if (function_exists('rank_math_the_breadcrumbs')) rank_math_the_breadcrumbs(); ?>
                <h1 class="h2 montserrat brown suptitle_arrow"><?php echo $title;?></h1>
                <p><?php echo get_field('job_header_description');?></p>
                <p class="mt-5">
                    <a href="#offers" class="btn bg-beige white btn-lg btn-round-corner">Voir les offres</a>
                </p>
            </div>
            <div class="col-12  col-xl-7">
                <div class="mosaic_bloc row">
                    <?php
                    if(get_field('job_header_gallery')){
                        $gallery = get_field('job_header_gallery');
                        foreach ($gallery as $img){

                            ?>
                            <div class="item pentagon" style="background: url(<?php echo $img['sizes']['c_medium_false'];?>) no-repeat center center / cover;">
                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container">
    <div class="row">
        <div class="col-12 p-2 p-md-5 text-center">
            <h2 class="h3 brown"><?php echo get_field('activity_title');?></h2>
        </div>
    </div>
    <div class="row domain_slider_part">
        <div class="col-12 domain_slider">
        <?php
        $domains = get_field('domains');
        foreach ($domains as $domain){
            $bg = $domain['domain_bg'];
            ?>
            <div class="item" style="background:url(<?php echo $bg['sizes']['c_slider'];?>) no-repeat center center / cover;">
                <div class="domain_info">
                    <div class="domain_txt white">
                        <h3 class="h3"><?php echo $domain['domain_title'];?></h3>
                        <p><?php echo $domain['domain_description'];?></p>
                    </div>
                </div>
            </div>
            <?php
        }
        ?>
        </div>
        <div class="controls" id="offers">
            <span class="btn-prev bg-beige white btn" href="#"></span>
            <span class="btn-next bg-beige white btn" href="#"></span>
        </div>
    </div>
</div>

<div  class="container">
    <div class="row">
        <div class="col-12 p-2 p-md-5 text-center">
            <h2 class="h3 brown">Découvrir nos offres <strong>d'emploi</strong></h2>
        </div>
    </div>
    <div class="row">
        <?php
        $args = array(
          'post_type' => 'emploi',
          'posts_per_page' => 4,
        );
        query_posts( $args );
        while ( have_posts() ) : the_post();
                    $thumb_id = get_post_thumbnail_id();
                    $thumb_url = wp_get_attachment_image_src($thumb_id,'large', true);
                    if($nb%2==0){
                        $order1 = 'order-1 txt';
                        $order2 = 'order-2';
                    }else{
                        $order2 = 'order-1';
                        $order1 = 'order-2 txt';
                    }
                    ?>
            <a href="<?php echo get_permalink();?>" class="actu_item col-12  col-lg-6 p-5">
                <div class="row">
                    <div class="col-4 relative <?php echo $order1;?>">
                        <div class="actu_title bg-brown white">
                            <ul class="list-inline social_share job_share">
                                <?php
                                if(get_field('job_type')){
                                    ?>
                                    <li class="list-inline-item cream1">
                                        <span class="icon icon-briefcase-alt"></span>
                                        <?php echo get_field('job_type');?>
                                    </li>
                                    <?php
                                }
                                ?>
                                <?php
                                if(get_field('job_location')){
                                    ?>
                                    <li class="list-inline-item cream1">
                                        <span class="icon icon-map-marker"></span>
                                        <?php echo get_field('job_location');?>
                                    </li>
                                    <?php
                                }
                                ?>
                            </ul>
                            <h2 class="h3"><?php echo get_the_title();?></h2>
                            <p>Voir l'offre</p>
                        </div>
                    </div>
                    <div class="col-8 actu_img <?php echo $order2;?>" style="background:url(<?php echo $thumb_url[0];?>) no-repeat center center / cover">
                        <img src="<?php echo $thumb_url[0];?>" alt="<?php echo get_the_title();?>" class="img-fluid d-none">
                    </div>
                </div>
            </a>
            <?php
                $nb++;
        endwhile;
        wp_reset_query();
        ?>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        <div class="col-12 col-xl-10 offset-xl-2 bg-cream1 candidat_part">
            <div class="row">
                <div class="col-12 col-lg-4 col-xl-4 candidat_img d-none d-lg-block">
                    <?php
                    $candidat_img = get_field('candidat_img');
                    ?>
                    <img src="<?php echo $candidat_img['sizes']['c_medium_false'];?>" alt="<?php echo $candidat_img['alt'];?>" class="mask img-fluid">
                </div>
                <div class="col-12 col-lg-8 col-xl-8 candidat_txt text-center">
                    <h2 class="h2 brown bold"><?php echo get_field('candidat_title');?></h2>
                    <p>
                        <?php echo get_field('candidat_description');?>
                    </p>
                    <p class="mt-5">
                        <a href="" class="btn btn-lg btn-round-corner bg-brown white" data-bs-toggle="modal" data-bs-target="#formModal">Je postule</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal -->
<div class="modal fade" id="formModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <div class="modal-content p-3">
            <div class="modal-header">
                <h5 class="modal-title h3" id="exampleModalLabel">Je postule</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php
                echo do_shortcode('[contact-form-7 id="419" title="candidature spontanée"]');
                ?>
            </div>
        </div>
    </div>
</div>


<?php get_footer(); ?>

