<?php
/*
  * template name: Choisir son carton
  * */
get_header(); ?>
<div class="banner_page_choice container">
    <div class="row">
        <div class="col-12">
            <?php if (function_exists('rank_math_the_breadcrumbs')) rank_math_the_breadcrumbs(); ?>
            <h1 class="montserrat brown "><?php echo get_the_title();?></h1>
        </div>
    </div>
    <div class="row">
        <div class="col-12 col-sm-6 col-md-6 mb-3 col-lg-5 offset-lg-1  col-xl-3">
            <?php
            $qtties = get_terms( array(
                'taxonomy' => 'pdt_qtty',
                'hide_empty' => false,
            ) );
            ?>
            <select id="choice_qtties" name="choice_qtties" data-form="quantites" class="form-select top_choice"
                    data-jplist-control="select-filter"
                    data-group="group1"
                    data-name="name1">
                <option
                        value="0"
                        data-path="default">Entre X et Y
                </option>
                <?php
                foreach ($qtties as $qtty){
                    ?>
                    <option
                            value="<?php echo $qtty->name;?>"
                            data-path=".qtty_<?php echo $qtty->slug;?>"
                    ><?php echo $qtty->name;?>
                    </option>
                    <?php
                }
                ?>
            </select>
            <label for="" class="form-label">Quantité</label>
        </div>
        <div class="col-12 col-sm-6 col-md-6 mb-3  col-lg-5 offset-lg-1 col-xl-3">
            <?php
            $transports = get_terms( array(
                'taxonomy' => 'pdt_transport',
                'hide_empty' => false,
            ) );
            ?>
            <select id="choice_transports" name="choice_transports" data-form="transports" class="form-select top_choice"
                    data-jplist-control="select-filter"
                    data-group="group1"
                    data-name="name2">
                <option
                        value="0"
                        data-path="default">Moyen de transport
                </option>
                <?php
                foreach ($transports as $transport){
                    ?>
                    <option
                            value="<?php echo $transport->name;?>"
                            data-path=".transport_<?php echo $transport->slug;?>"
                    ><?php echo $transport->name;?>
                    </option>
                    <?php
                }
                ?>
            </select>
            <label for="" class="form-label">Envoi par</label>
        </div>
        <div class="col-12 col-sm-6 col-md-6 mb-3  col-lg-5 offset-lg-1 col-xl-3">
            <?php
            $stocks = get_terms( array(
                'taxonomy' => 'pdt_stock',
                'hide_empty' => false,
            ) );
            ?>
            <select id="choice_stocks" name="choice_stocks" data-form="stocks" class="form-select top_choice"
                    data-jplist-control="select-filter"
                    data-group="group1"
                    data-name="name3">
                <option
                        value="0"
                        data-path="default">Entre X et X jours
                </option>
                <?php
                foreach ($stocks as $stock){
                    ?>
                    <option
                            value="<?php echo $stock->name;?>"
                            data-path=".stock_<?php echo $stock->slug;?>"
                    ><?php echo $stock->name;?>
                    </option>
                    <?php
                }
                ?>
            </select>
            <label for="" class="form-label">Stocké</label>
        </div>
        <div class="col-12 col-sm-6 col-md-6 mb-3  col-lg-5 offset-lg-1 col-xl-3">
            <?php
            $prints = get_terms( array(
                'taxonomy' => 'pdt_print',
                'hide_empty' => false,
            ) );
            ?>
            <select id="choice_stocks" name="choice_prints" data-form="prints" class="form-select top_choice"
                    data-jplist-control="select-filter"
                    data-group="group1"
                    data-name="name4">
                <option
                        value="0"
                        data-path="default">Nombre de couleurs
                </option>
                <?php
                foreach ($prints as $print){
                    ?>
                    <option
                            value="<?php echo $print->name;?>"
                            data-path=".print_<?php echo $print->slug;?>"
                    ><?php echo $print->name;?>
                    </option>
                    <?php
                }
                ?>
            </select>
            <label for="" class="form-label">Impression</label>
        </div>
        <div class="col-12 col-sm-6 col-md-6 mb-3  col-lg-5 offset-lg-1 col-xl-3">
            <?php
            $cannelures = get_terms( array(
                'taxonomy' => 'pdt_cannelure',
                'hide_empty' => false,
            ) );
            ?>
            <select id="choice_cannelures" name="choice_cannelures" data-form="cannelures" class="form-select top_choice"
                    data-jplist-control="select-filter"
                    data-group="group1"
                    data-name="name5">
                <option
                        value="0"
                        data-path="default">Nombre de cannelures
                </option>
                <?php
                foreach ($cannelures as $cannelure){
                    ?>
                    <option
                            value="<?php echo $cannelure->name;?>"
                            data-path=".cann_<?php echo $cannelure->slug;?>"
                    ><?php echo $cannelure->name;?>
                    </option>
                    <?php
                }
                ?>
            </select>
            <label for="" class="form-label">Type de cannelure</label>
        </div>
        <div class="col-12 col-sm-6 col-md-6 mb-3  col-lg-5 offset-lg-1 col-xl-3">
            <?php
            $weights = get_terms( array(
                'taxonomy' => 'pdt_weight',
                'hide_empty' => false,
            ) );
            ?>
            <select id="choice_weights" name="choice_weights" data-form="weights" class="form-select top_choice"
                    data-jplist-control="select-filter"
                    data-group="group1"
                    data-name="name6">
                <option
                        value="0"
                        data-path="default">De X à Y Kg
                </option>
                <?php
                foreach ($weights as $weight){
                    ?>
                    <option
                            value="<?php echo $weight->name;?>"
                            data-path=".weight_<?php echo $weight->slug;?>"
                    ><?php echo $weight->name;?>
                    </option>
                    <?php
                }
                ?>
            </select>
            <label for="" class="form-label">Poids de l'emballage</label>
        </div>
    </div>
</div>


<div class="container-fluid bg-cream1 py-5">
    <div class="container py-5">
        <div id="jplistContent" class="row" data-jplist-group="group1">

            <?php
            $args = array(
               'post_type' => 'produit',
               'posts_per_page' => -1,
            );
            query_posts( $args );

            if (have_posts()) : while (have_posts()) : the_post(); ?>
                <?php
                $pdt_imgs = get_field('pdt_imgs');
                $img_data = $pdt_imgs[0];
                //fields
                $qtties = $transports = $stocks = $prints = $cannelures = $weights = null;
                $qtty = $transport = $qttySlug = $transportSlug = $stockSlug = $stock = $printSlug = $print = $cannelure = $cannelureSlug = $weightSlug = $weight = null;
                $qtty = get_the_terms(get_the_ID(), 'pdt_qtty');
                foreach ($qtty as $item) {
                    $qtties .= ' qtty_'.$item->slug;
                }

                $transport = get_the_terms(get_the_ID(), 'pdt_transport');
                foreach ($transport as $item) {
                    $transports .= ' transport_'.$item->slug;
                }

                $stock = get_the_terms(get_the_ID(), 'pdt_stock');
                foreach ($stock as $item) {
                    $stocks .= ' stock_'.$item->slug;
                }

                $print = get_the_terms(get_the_ID(), 'pdt_print');
                foreach ($print as $item) {
                    $prints .= ' print_'.$item->slug;
                }

                $cannelure = get_the_terms(get_the_ID(), 'pdt_cannelure');
                foreach ($cannelure as $item) {
                    $cannelures .= ' cann_'.$item->slug;
                }

                $weight = get_the_terms(get_the_ID(), 'pdt_weight');
                foreach ($weight as $item) {
                    $weights .= ' weight_'.$item->slug;
                }

                ?>
                <div class="col-12 col-sm-6 col-md-6 col-lg-4" data-jplist-item>
                    <a href="<?php echo get_permalink();?>" class="pdt_item d-block p-3">
                        <p class="pdt_transport d-none <?php echo $transports;?>"><?php echo $transports;?></p>
                        <p class="pdt_qtty d-none <?php echo $qtties;?>"><?php echo $qtties;?></p>
                        <p class="pdt_stock d-none <?php echo $stocks;?>"><?php echo $stocks;?></p>
                        <p class="pdt_print d-none <?php echo $prints;?>"><?php echo $prints;?></p>
                        <p class="pdt_cannelure d-none <?php echo $cannelures;?>"><?php echo $cannelures;?></p>
                        <p class="pdt_weight d-none <?php echo $weights;?>"><?php echo $weights;?></p>
                        <div class="pdt_item_img" style="background:url(<?php echo $img_data['sizes']['c_medium_false'];?>) no-repeat center center / cover">

                        </div>
                        <img src="<?php echo $img_data['sizes']['c_medium_false'];?>" alt="<?php echo get_the_title();?>" class="img-fluid d-none">
                        <h2 class="m-4 h3 brown bold underlined"><?php echo get_the_title();?></h2>
                    </a>
                </div>



            <?php endwhile; ?>
            <?php endif; ?>

            <!-- no results control -->
            <div data-jplist-control="no-results" data-group="group1" data-name="no-results">
                <p class="bold text-center">
                    Aucun de nos produits <br>ne correspond à vos critères de recherche...
                </p>
            </div>
        </div>
        <p id="choice_form"></p>
    </div>
</div>
<div  class="container py-5">
    <div class="row">
        <div class="col-12 col-lg-8 offset-lg-2 col-xl-6 offset-xl-3 py-5">
            <?php echo do_shortcode('[contact-form-7 id="219" title="Devis"]');?>
        </div>
    </div>
</div>

<?php get_footer(); ?>
<script>
    jplist.init();
</script>
