<?php
$count_posts = wp_count_posts('actualite');
$total_posts = $count_posts->publish;
if($temp='new'){
    $news_title = 'Découvrir nos autres <strong>actualités</strong>';
}else{
    $news_title = 'Découvrir <strong>l’actualité</strong> de CPL OP Emballages <br>
                    et du <strong>carton ondulé</strong> ...';
}


if($total_posts>3){
?>

<div class="container-fluid news_part bg-white">
    <div class="container">
        <div class="row">
            <div class="col-12 mt-5">
                <p class="suptitle suptitle_arrow">L'actualité</p>
            </div>
        </div>
        <div class="row">
            <div class="col-12 col-md-9">
                <h2 class="h2 brown news_part_title"><?php echo $news_title;?></h2>
            </div>
            <div class="col-12 col-md-3">
                <p class="text-end archive_link">
                    <a href="<?php echo get_post_type_archive_link('actualite');?>" class="text-uppercase brown">Tout Découvrir</a>
                </p>
            </div>
        </div>
    </div>

<div class="swiper-container row mt-5">
    <div class="slick-news">
        <?php
        if($temp=='new'){

            $args = array(
                'post_type' => 'actualite',
                'posts_per_page' => 12,
                'post__not_in' => array(get_the_id()),
            );
        }else {
            $args = array(
                'post_type' => 'actualite',
                'posts_per_page' => 12,

            );
        }
        query_posts( $args );
        while ( have_posts() ) : the_post();
            ?>
            <div class="swiper-slide item col-4" >
                <div class="row news_bloc">
                    <div class="col-12 col-lg-6 col-xl-5 bg-cream1 brown d-flex align-items-start flex-column p-5">
                        <p class="h4 text-center mb-auto mt-5"><?php echo get_the_title();?></p>
                        <p class="news_link"><a href="<?php echo get_permalink();?>" class="text-uppercase brown">Lire la suite</a></p>
                    </div>
                    <?php
                    $thumb_id = get_post_thumbnail_id();
                    $thumb_url = wp_get_attachment_image_src($thumb_id,'c_small', true);
                    ?>
                    <div class="col-12 col-lg-6 col-xl-7 p-0" style="background:url(<?php echo $thumb_url[0];?>) no-repeat center center / cover;">
                        <?php
                        $thumb_id = get_post_thumbnail_id();
                        $thumb_url = wp_get_attachment_image_src($thumb_id,'c_small', true);
                        ?>
                        <img src="<?php echo $thumb_url[0];?>" alt="" class="img-fluid img-fluid-height-100">
                    </div>
                </div>
            </div>
        <?php
        endwhile;
        wp_reset_query();
        ?>
    </div>

    <div class="swiper-button-prev"><i class="white bi bi-chevron-left"></i></div>
    <div class="swiper-button-next"><i class="white bi bi-chevron-right"></i></div>
</div>
<?php
}else{
    if($total_posts==1){
        $classCol = 'offset-lg-4';
    }elseif($total_posts==2){
        $classCol = 'offset-lg-2';
    }else{
        $classCol = '';
    }
    ?>
        <div class="row">
        <?php
    $args = array(
        'post_type' => 'actualite',
        'posts_per_page' => 3,

    );
    $nb=1;
    query_posts( $args );
    while ( have_posts() ) : the_post();
        ?>
        <div class="col-12 col-md-6 col-lg-4 <?php if($nb==1){echo $classCol;};?>" >
            <div class="row news_bloc">
                <div class="col-12 col-lg-6 col-xl-5 bg-cream1 brown d-flex align-items-start flex-column p-5">
                    <p class="h4 text-center mb-auto mt-5"><?php echo get_the_title();?></p>
                    <p class="news_link"><a href="<?php echo get_permalink();?>" class="text-uppercase brown">Lire la suite</a></p>
                </div>
                <?php
                $thumb_id = get_post_thumbnail_id();
                $thumb_url = wp_get_attachment_image_src($thumb_id,'c_medium', true);
                ?>
                <div class="col-12 col-lg-6 col-xl-7 p-0 news_bloc_img">
                    <?php
                    $thumb_id = get_post_thumbnail_id();
                    $thumb_url = wp_get_attachment_image_src($thumb_id,'c_medium', true);
                    ?>
                    <img src="<?php echo $thumb_url[0];?>" alt="" class="img-fluid img-fluid-height-100">
                </div>
            </div>
        </div>
    <?php
        $nb++;
    endwhile;
    wp_reset_query();
    ?>
        </div>
</div>
    <?php
}
?>


