<?php
setlocale(LC_TIME, "fr_FR");
?>

<!doctype html>
<!--[if IEMobile 7 ]>
<html <?php language_attributes(); ?>class="no-js iem7"> <![endif]-->
<!--[if lt IE 7 ]>
<html <?php language_attributes(); ?> class="no-js ie6"> <![endif]-->
<!--[if IE 7 ]>
<html <?php language_attributes(); ?> class="no-js ie7"> <![endif]-->
<!--[if IE 8 ]>
<html <?php language_attributes(); ?> class="no-js ie8"> <![endif]-->
<!--[if (gte IE 9)|(gt IEMobile 7)|!(IEMobile)|!(IE)]><!-->
<html <?php language_attributes(); ?> class="no-js"><!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title><?php wp_title('|', true, 'right'); ?></title>

    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo get_template_directory_uri(); ?>/favicon/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo get_template_directory_uri(); ?>/favicon/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo get_template_directory_uri(); ?>/favicon/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo get_template_directory_uri(); ?>/favicon/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo get_template_directory_uri(); ?>/favicon/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo get_template_directory_uri(); ?>/favicon/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo get_template_directory_uri(); ?>/favicon/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo get_template_directory_uri(); ?>/favicon/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_template_directory_uri(); ?>/favicon/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo get_template_directory_uri(); ?>/favicon/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo get_template_directory_uri(); ?>/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo get_template_directory_uri(); ?>/favicon/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_template_directory_uri(); ?>/favicon/favicon-16x16.png">
    <link rel="manifest" href="<?php echo get_template_directory_uri(); ?>/favicon/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo get_template_directory_uri(); ?>/favicon/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">


    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, user-scalable=no">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php wp_head(); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.0/font/bootstrap-icons.css">
    <link href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/icomoon-17/style.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/2021.css">
    <?php
    if(is_front_page() || is_singular('actualite')){
        echo '<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/slick.css" />';
    }
    ?>

</head>
<body <?php body_class(); ?>>

<div class="container-fluid bg-white header fixed-top">
    <div class="row">
        <div class="col-12">
            <nav class="navbar navbar-expand-lg ">
                <a class="navbar-brand" href="/">
                    <img loading="lazy"
                         src="<?php echo get_template_directory_uri(); ?>/images/Logo_CPL-OP.png"
                         alt="<?php echo bloginfo('name'); ?>" class="img-fluid">
                </a>
                <button class="navbar-toggler collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
                        aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <?php wp_bootstrap_main_nav(); // Adjust using Menus in Wordpress Admin ?>
                    <div class="contact_btn bg-beige d-none d-lg-block">
                        <a href="<?php echo get_permalink(254);?>" class="white arrow">
                            Contactez-nous
                        </a>
                        <ul class="contact_btn_list">
                            <li>
                                <p>Via notre formulaire</p>
                                <a href="<?php echo get_permalink(254);?>">Contactez-nous <i class="icon icon-arrow-right"></i></a>
                            </li>
                            <li>
                                <p class="">Via notre formulaire</p>
                                <a href="<?php echo get_permalink(409);?>">Demandez un devis <i class="icon icon-arrow-right"></i></a>
                            </li>
                            <li>
                                <p>Via téléphone</p>
                                <?php
                                $phone = get_field('phone_2','options');
                                ?>
                                <a href="tel:<?php echo str_replace(' ','',$phone);?>"><?php echo $phone;?></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </nav>
        </div>
    </div>
    </div>




