<?php get_header(); 
$header_banner_url = get_template_directory_uri().'/images/default_banner.jpg';
?>	
<div class="container-fluid banner" style="background:url(<?php echo $header_banner_url;?>) no-repeat center center / cover">
	<span class="cover"></span>
	<div class="banner_txt">

	</div>
	<div class="wave">
		<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none">
		  <path fill="#ffffff" fill-opacity="1" d="M0,96L80,122.7C160,149,320,203,480,186.7C640,171,800,85,960,74.7C1120,64,1280,128,1360,160L1440,192L1440,320L1360,320C1280,320,1120,320,960,320C800,320,640,320,480,320C320,320,160,320,80,320L0,320Z"></path>
		</svg>	
	</div>		
</div>			

<div class="container">
	<div id="content" class="clearfix row">
				
		<div id="main" class="col-sm-12 col-md-10 offset-md-1 clearfix p-5" role="main">
			<?php
			$term = get_queried_object();
			//var_dump(category_description());
			if(category_description()){
				echo '<div class="post_content">'.category_description().'</div>';
				
			}
			
			?>
			<?php
			if ( function_exists('yoast_breadcrumb') ) {yoast_breadcrumb('<p id="breadcrumbs" class="blue">','</p>');}
			?>		
			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
			
			<article id="post-<?php the_ID(); ?>" <?php post_class('clearfix p-2'); ?> role="article">
				
				<header>
					<h2 class="h3"><?php the_title(); ?></h2>
				</header> <!-- end article header -->
			
				<div class="row">
					<?php if(the_post_thumbnail()){ ?>
					<div class="col-12 col-sm-3">
					<a class="" href="<?php echo get_permalink();?>"><?php the_post_thumbnail( 'thumbnail' ); ?></a>
					</div>
					<?php } ?>
					<div class="col-12 col-sm-9">
					<?php the_excerpt(); ?>
					<a class="btn btn-sm bg_green white" href="<?php echo get_permalink();?>">Lire la suite</a>
					</div>
				</div> <!-- end article section -->
				
				<footer>
					<hr>
				</footer> <!-- end article footer -->
			
			</article> <!-- end article -->
			
			<?php endwhile; ?>	
			
			<?php if (function_exists('wp_bootstrap_page_navi')) { // if expirimental feature is active ?>
				
				<?php wp_bootstrap_page_navi(); // use the page navi function ?>

			<?php } else { // if it is disabled, display regular wp prev & next links ?>
				<nav class="wp-prev-next">
					<ul class="pager">
						<li class="previous"><?php next_posts_link(_e('&laquo; Older Entries', "wpbootstrap")) ?></li>
						<li class="next"><?php previous_posts_link(_e('Newer Entries &raquo;', "wpbootstrap")) ?></li>
					</ul>
				</nav>
			<?php } ?>
						
			
			<?php else : ?>
			
			<article id="post-not-found">
				<header>
					<h1><?php _e("No Posts Yet", "wpbootstrap"); ?></h1>
				</header>
				<section class="post_content">
					<p><?php _e("Sorry, What you were looking for is not here.", "wpbootstrap"); ?></p>
				</section>
				<footer>
				</footer>
			</article>
			
			<?php endif; ?>
	
		</div> <!-- end #main -->
		
		
	</div> <!-- end #content -->

</div> 

	
<?php get_footer(); ?>
